// Chat Widget Script - VERSION LOCALE MODIFIÉE
console.log("Chargement de la version LOCALE modifiée du chat-widget.js");
(function() {
    // Create and inject styles
    const styles = `
        .n8n-chat-widget {
            --chat--color-primary: var(--n8n-chat-primary-color, #854fff);
            --chat--color-secondary: var(--n8n-chat-secondary-color, #6b3fd4);
            --chat--color-background: var(--n8n-chat-background-color, #ffffff);
            --chat--color-font: var(--n8n-chat-font-color, #333333);
            font-family: 'Geist Sans', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
        }

        .n8n-chat-widget .chat-container {
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 1000;
            display: none;
            width: 380px;
            height: 600px;
            background: var(--chat--color-background);
            border-radius: 12px;
            box-shadow: 0 8px 32px rgba(133, 79, 255, 0.15);
            border: 1px solid rgba(133, 79, 255, 0.2);
            overflow: hidden;
            font-family: inherit;
        }

        .n8n-chat-widget .chat-container.position-left {
            right: auto;
            left: 20px;
        }

        .n8n-chat-widget .chat-container.open {
            display: flex;
            flex-direction: column;
        }

        .n8n-chat-widget .brand-header {
            padding: 16px;
            display: flex;
            align-items: center;
            gap: 12px;
            border-bottom: 1px solid rgba(133, 79, 255, 0.1);
            position: relative;
        }

        .n8n-chat-widget .close-button {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--chat--color-font);
            cursor: pointer;
            padding: 4px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: color 0.2s;
            font-size: 20px;
            opacity: 0.6;
        }

        .n8n-chat-widget .close-button:hover {
            opacity: 1;
        }

        .n8n-chat-widget .brand-header img {
            width: 32px;
            height: 32px;
        }

        .n8n-chat-widget .brand-header span {
            font-size: 18px;
            font-weight: 500;
            color: var(--chat--color-font);
        }

        .n8n-chat-widget .new-conversation {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            padding: 20px;
            text-align: center;
            width: 100%;
            max-width: 300px;
        }

        .n8n-chat-widget .welcome-text {
            font-size: 24px;
            font-weight: 600;
            color: var(--chat--color-font);
            margin-bottom: 24px;
            line-height: 1.3;
        }

        .n8n-chat-widget .new-chat-btn {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            width: 100%;
            padding: 16px 24px;
            background: linear-gradient(135deg, var(--chat--color-primary) 0%, var(--chat--color-secondary) 100%);
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: transform 0.3s;
            font-weight: 500;
            font-family: inherit;
            margin-bottom: 12px;
        }

        .n8n-chat-widget .new-chat-btn:hover {
            transform: scale(1.02);
        }

        .n8n-chat-widget .message-icon {
            width: 20px;
            height: 20px;
        }

        .n8n-chat-widget .response-text {
            font-size: 14px;
            color: var(--chat--color-font);
            opacity: 0.7;
            margin: 0;
        }

        .n8n-chat-widget .chat-interface {
            display: none;
            flex-direction: column;
            height: 100%;
            position: relative; /* Pour le positionnement de la barre de chat */
        }

        .n8n-chat-widget .chat-interface.active {
            display: flex;
        }

        .n8n-chat-widget .chat-messages {
            flex: 1;
            overflow-y: auto;
            padding: 20px;
            padding-bottom: 80px; /* Espace pour la barre de saisie fixe */
            background: var(--chat--color-background);
            display: flex;
            flex-direction: column;
            height: calc(100% - 60px); /* Ajuster pour laisser de la place à la barre de saisie */
        }

        .n8n-chat-widget .chat-message {
            padding: 12px 16px;
            margin: 8px 0;
            border-radius: 12px;
            max-width: 80%;
            word-wrap: break-word;
            font-size: 14px;
            line-height: 1.5;
        }

        .n8n-chat-widget .chat-message.user {
            background: linear-gradient(135deg, var(--chat--color-primary) 0%, var(--chat--color-secondary) 100%);
            color: white;
            align-self: flex-end;
            box-shadow: 0 4px 12px rgba(133, 79, 255, 0.2);
            border: none;
        }
        
        /* Style pour les messages audio */
        .n8n-chat-widget .audio-message {
            padding: 8px 12px;
        }
        
        .n8n-chat-widget .audio-player-container {
            display: flex;
            align-items: center;
            margin-top: 5px;
        }
        
        .n8n-chat-widget .audio-player {
            width: 100%;
            height: 32px;
        }
        
        .n8n-chat-widget .audio-transcription {
            margin-top: 8px;
            font-style: italic;
            opacity: 0.8;
        }

        .n8n-chat-widget .chat-message.bot {
            background: var(--chat--color-background);
            border: 1px solid rgba(133, 79, 255, 0.2);
            color: var(--chat--color-font);
            align-self: flex-start;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        .n8n-chat-widget .chat-input {
            padding: 16px;
            background: var(--chat--color-background);
            border-top: 1px solid rgba(133, 79, 255, 0.1);
            display: flex;
            gap: 8px;
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            z-index: 10;
            box-shadow: 0 -4px 12px rgba(0, 0, 0, 0.05);
        }

        .n8n-chat-widget .chat-input textarea {
            flex: 1;
            padding: 12px;
            border: 1px solid rgba(133, 79, 255, 0.2);
            border-radius: 8px;
            background: var(--chat--color-background);
            color: var(--chat--color-font);
            resize: none;
            font-family: inherit;
            font-size: 14px;
        }

        .n8n-chat-widget .chat-input textarea::placeholder {
            color: var(--chat--color-font);
            opacity: 0.6;
        }

        .n8n-chat-widget .chat-input button {
            background: linear-gradient(135deg, var(--chat--color-primary) 0%, var(--chat--color-secondary) 100%);
            color: white;
            border: none;
            border-radius: 8px;
            padding: 0 20px;
            cursor: pointer;
            transition: transform 0.2s;
            font-family: inherit;
            font-weight: 500;
        }

        .n8n-chat-widget .chat-input button:hover {
            transform: scale(1.05);
        }

        .n8n-chat-widget .chat-toggle {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 60px;
            height: 60px;
            border-radius: 30px;
            background: linear-gradient(135deg, var(--chat--color-primary) 0%, var(--chat--color-secondary) 100%);
            color: white;
            border: none;
            cursor: pointer;
            box-shadow: 0 4px 12px rgba(133, 79, 255, 0.3);
            z-index: 999;
            transition: transform 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .n8n-chat-widget .chat-toggle.position-left {
            right: auto;
            left: 20px;
        }

        .n8n-chat-widget .chat-toggle:hover {
            transform: scale(1.05);
        }

        .n8n-chat-widget .chat-toggle svg {
            width: 24px;
            height: 24px;
            fill: currentColor;
        }

        .n8n-chat-widget .chat-footer {
            padding: 8px;
            text-align: center;
            background: var(--chat--color-background);
            border-top: 1px solid rgba(133, 79, 255, 0.1);
        }

        .n8n-chat-widget .chat-footer a {
            color: var(--chat--color-primary);
            text-decoration: none;
            font-size: 12px;
            opacity: 0.8;
            transition: opacity 0.2s;
            font-family: inherit;
        }

        .n8n-chat-widget .chat-footer a:hover {
            opacity: 1;
        }
        /* Loader Styles */
        .chat-loader {
            display: none;
            text-align: center;
            padding: 20px;
            position: absolute;
            bottom: 80px; /* Positionné juste au-dessus de la barre de saisie */
            left: 0;
            right: 0;
            z-index: 15;
            background-color: rgba(255, 255, 255, 0.8); /* Fond semi-transparent */
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }
        
        .chat-loader i {
            font-size: 24px;
            color: var(--chat--color-primary);
            margin-right: 10px;
        }
        
        .chat-loader span {
            display: inline-block;
            font-size: 16px;
            color: var(--chat--color-primary);
            font-weight: 500;
        }
    `;

    // Load Geist font
    const fontLink = document.createElement('link');
    fontLink.rel = 'stylesheet';
    fontLink.href = 'https://cdn.jsdelivr.net/npm/geist@1.0.0/dist/fonts/geist-sans/style.css';
    document.head.appendChild(fontLink);
    
    // Load Font Awesome for modern icons
    const iconLink = document.createElement('link');
    iconLink.rel = 'stylesheet';
    iconLink.href = 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css';
    document.head.appendChild(iconLink);

    // Inject styles
    const styleSheet = document.createElement('style');
    styleSheet.textContent = styles;
    document.head.appendChild(styleSheet);

    // Default configuration
    const defaultConfig = {
        webhook: {
            url: '',
            route: ''
        },
        branding: {
            logo: '',
            name: '',
            welcomeText: '',
            responseTimeText: '',
            poweredBy: {
                text: 'Powered by CSEFRS',
                link: 'https://csefrs.ma'
            }
        },
        style: {
            primaryColor: '',
            secondaryColor: '',
            position: 'right',
            backgroundColor: '#ffffff',
            fontColor: '#333333'
        }
    };

    // Merge user config with defaults
    const config = window.ChatWidgetConfig ? 
        {
            webhook: { ...defaultConfig.webhook, ...window.ChatWidgetConfig.webhook },
            branding: { ...defaultConfig.branding, ...window.ChatWidgetConfig.branding },
            style: { ...defaultConfig.style, ...window.ChatWidgetConfig.style }
        } : defaultConfig;

    // Prevent multiple initializations
    if (window.N8NChatWidgetInitialized) return;
    window.N8NChatWidgetInitialized = true;
    
    // Indiquer que notre version est chargée
    console.warn("VERSION LOCALE DU CHAT WIDGET INITIALISÉE - AVEC SUPPORT MULTILINGUE");

    // Variable pour stocker la langue sélectionnée
    window.selectedLanguage = 'fr';
    
    // Écouter les messages pour mettre à jour la langue
    window.addEventListener('message', function(event) {
        if (event.data && event.data.type === 'setLanguage') {
            window.selectedLanguage = event.data.language;
            console.log('Langue mise à jour dans l\'iframe:', window.selectedLanguage);
        }
    });

    let currentSessionId = '';

    // Create widget container
    const widgetContainer = document.createElement('div');
    widgetContainer.className = 'n8n-chat-widget';
    
    // Set CSS variables for colors
    widgetContainer.style.setProperty('--n8n-chat-primary-color', config.style.primaryColor);
    widgetContainer.style.setProperty('--n8n-chat-secondary-color', config.style.secondaryColor);
    widgetContainer.style.setProperty('--n8n-chat-background-color', config.style.backgroundColor);
    widgetContainer.style.setProperty('--n8n-chat-font-color', config.style.fontColor);

    const chatContainer = document.createElement('div');
    chatContainer.className = `chat-container${config.style.position === 'left' ? ' position-left' : ''}`;
    
    const newConversationHTML = `
        <div class="brand-header">
            <img src="${config.branding.logo}" alt="${config.branding.name}">
            <span>${config.branding.name}</span>
            <button class="close-button">×</button>
        </div>
        <div class="new-conversation">
            <h2 class="welcome-text">${config.branding.welcomeText}</h2>
            <button class="new-chat-btn">
                <svg class="message-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                    <path fill="currentColor" d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H5.2L4 17.2V4h16v12z"/>
                </svg>
                Commencer la discussion
            </button>
            <p class="response-text">${config.branding.responseTimeText}</p>
        </div>
    `;

    const chatInterfaceHTML = `
        <div class="chat-interface">
            <div class="brand-header">
                <img src="${config.branding.logo}" alt="${config.branding.name}">
                <span>${config.branding.name}</span>
                <button class="close-button">×</button>
            </div>
            <div class="chat-messages"></div>
            <div class="chat-loader">
                <i class="fas fa-circle-notch fa-spin"></i>
                <span>En attente de réponse...</span>
            </div>
            <div class="chat-input">
                <textarea placeholder="Tapez votre message ici..." rows="1"></textarea>
                <button type="submit" style="height: 40px;">Envoyer</button>
            </div>
            <div class="chat-footer">
                <a href="${config.branding.poweredBy.link}" target="_blank">${config.branding.poweredBy.text}</a>
            </div>
        </div>
    `;
    
    chatContainer.innerHTML = newConversationHTML + chatInterfaceHTML;
    
    const toggleButton = document.createElement('button');
    toggleButton.className = `chat-toggle${config.style.position === 'left' ? ' position-left' : ''}`;
    toggleButton.innerHTML = `
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
            <path d="M12 2C6.477 2 2 6.477 2 12c0 1.821.487 3.53 1.338 5L2.5 21.5l4.5-.838A9.955 9.955 0 0012 22c5.523 0 10-4.477 10-10S17.523 2 12 2zm0 18c-1.476 0-2.886-.313-4.156-.878l-3.156.586.586-3.156A7.962 7.962 0 014 12c0-4.411 3.589-8 8-8s8 3.589 8 8-3.589 8-8 8z"/>
        </svg>`;
    
    widgetContainer.appendChild(chatContainer);
    widgetContainer.appendChild(toggleButton);
    document.body.appendChild(widgetContainer);

    const newChatBtn = chatContainer.querySelector('.new-chat-btn');
    const chatInterface = chatContainer.querySelector('.chat-interface');
    const messagesContainer = chatContainer.querySelector('.chat-messages');
    const textarea = chatContainer.querySelector('textarea');
    const sendButton = chatContainer.querySelector('button[type="submit"]');
    const loader = chatContainer.querySelector('.chat-loader');

    function generateUUID() {
        return crypto.randomUUID();
    }

    async function startNewConversation() {
        currentSessionId = generateUUID();
        const data = [{
            action: "loadPreviousSession",
            sessionId: currentSessionId,
            route: config.webhook.route,
            metadata: {
                userId: ""
            }
        }];

        try {
            // Ajouter un timeout pour la requête fetch
            const controller = new AbortController();
            const timeoutId = setTimeout(() => controller.abort(), 60000); // 30 secondes timeout
            
            const response = await fetch(config.webhook.url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(data),
                signal: controller.signal
            }).catch(error => {
                if (error.name === 'AbortError') {
                    throw new Error("La requête a pris trop de temps, veuillez réessayer.");
                }
                throw error;
            });
            
            // N'oublions pas d'annuler le timeout
            clearTimeout(timeoutId);

            // Vérifier si la réponse est OK
            if (!response.ok) {
                throw new Error(`Erreur HTTP: ${response.status} ${response.statusText}`);
            }
            
            // Vérifier et traiter la réponse avec plus de robustesse
            let text;
            try {
                text = await response.text();
            } catch (error) {
                throw new Error(`Impossible de lire la réponse: ${error.message}`);
            }
            
            if (!text || text.trim() === '') {
                // Si la réponse est vide, on crée une réponse factice pour éviter l'erreur
                console.warn("Réponse vide du serveur, utilisation d'une réponse par défaut");
                text = JSON.stringify({output: "Bienvenue ! Comment puis-je vous aider aujourd'hui ?"});
            }
            
            // Essayer de parser le JSON avec plus de robustesse
            let responseData;
            try {
                responseData = JSON.parse(text);
            } catch (parseError) {
                console.error("Erreur de parsing JSON:", parseError);
                console.log("Réponse reçue:", text);
                
                // Créer une structure de données minimale si le parsing échoue
                responseData = {
                    output: "Bienvenue ! Comment puis-je vous aider aujourd'hui ?"
                };
            }

            // Préparation de l'interface chat
            chatContainer.querySelector('.brand-header').style.display = 'none';
            chatContainer.querySelector('.new-conversation').style.display = 'none';
            chatInterface.classList.add('active');

            // Traiter les données avec plus de sécurité
            let botResponse = "Bienvenue ! Comment puis-je vous aider aujourd'hui ?";
            
            if (responseData) {
                if (Array.isArray(responseData) && responseData.length > 0 && responseData[0].output) {
                    botResponse = responseData[0].output;
                } else if (!Array.isArray(responseData) && responseData.output) {
                    botResponse = responseData.output;
                }
            }
            
            const botMessageDiv = document.createElement('div');
            botMessageDiv.className = 'chat-message bot';
            
            // Convertir les \n en <br/> pour le formatage HTML et éviter les doublons
            // 1. Remplacer les sauts de ligne multiples par un seul
            let cleanedResponse = botResponse.replace(/\n{2,}/g, '\n');
            // 2. Convertir les \n en <br/>
            let formattedResponse = cleanedResponse.replace(/\n/g, '<br/>');
            // 3. Éliminer les <br/><br/> ou <br><br> éventuellement présents
            let processedResponse = formattedResponse.replace(/(<br\s*\/?>\s*){2,}/gi, '<br/>');
            // 4. Supprimer les <br/> qui suivent un </li>
            let afterListResponse = processedResponse.replace(/<\/li>\s*<br\s*\/?>/gi, '</li>');
            // 5. Supprimer les <br/> avant <ul>
            let beforeUlResponse = afterListResponse.replace(/<br\s*\/?>\s*<ul/gi, '<ul');
            // 6. Supprimer les <br/> après </ul>
            let afterUlResponse = beforeUlResponse.replace(/<\/ul>\s*<br\s*\/?>/gi, '</ul>');
            // 7. Supprimer les <br/> avant <ol>
            let beforeOlResponse = afterUlResponse.replace(/<br\s*\/?>\s*<ol/gi, '<ol');
            // 8. Supprimer les <br/> après </ol>
            let afterOlResponse = beforeOlResponse.replace(/<\/ol>\s*<br\s*\/?>/gi, '</ol>');
            // 9. Supprimer les <br/> entre <ul> et <li>
            let cleanUlResponse = afterOlResponse.replace(/<ul>\s*<br\s*\/?>/gi, '<ul>');
            // 10. Supprimer les <br/> entre <ol> et <li>
            let finalResponse = cleanUlResponse.replace(/<ol>\s*<br\s*\/?>/gi, '<ol>');
            
            // Utiliser innerHTML pour afficher le contenu formaté
            botMessageDiv.innerHTML = finalResponse;
            
            // Appliquer la direction RTL si la réponse est en arabe
            try {
                if (window.selectedLanguage === 'ar') {
                    botMessageDiv.style.direction = 'rtl';
                    botMessageDiv.style.textAlign = 'right';
                } else {
                    botMessageDiv.style.direction = 'ltr';
                    botMessageDiv.style.textAlign = 'left';
                }
            } catch (e) {
                console.warn("Impossible d'appliquer la direction du texte:", e);
            }
            
            messagesContainer.appendChild(botMessageDiv);
            messagesContainer.scrollTop = messagesContainer.scrollHeight;
        } catch (error) {
            console.error("Error:", error);
            
            // Afficher quand même l'interface de chat
            chatContainer.querySelector('.brand-header').style.display = 'none';
            chatContainer.querySelector('.new-conversation').style.display = 'none';
            chatInterface.classList.add('active');
            
            // Afficher un message d'erreur plus informatif dans le chat
            const errorMessageDiv = document.createElement('div');
            errorMessageDiv.className = 'chat-message bot';
            
            let errorMessage = "Impossible de communiquer avec le serveur.";
            if (error.message) {
                if (error.message.includes("JSON")) {
                    errorMessage = "Le serveur a envoyé une réponse que je ne peux pas comprendre.";
                } else if (error.message.includes("HTTP")) {
                    errorMessage = "Erreur de connexion au serveur.";
                } else if (error.message.includes("timeout") || error.message.includes("trop de temps")) {
                    errorMessage = "La connexion au serveur a pris trop de temps.";
                }
            }
            
            errorMessageDiv.innerHTML = `
                <div style="color: #a94442; background-color: #f2dede; padding: 10px; border-radius: 4px; border: 1px solid #ebccd1;">
                    <strong>Désolé, une erreur est survenue lors de l'initialisation.</strong><br>
                    ${errorMessage} Vous pouvez tout de même essayer d'envoyer un message.
                </div>
            `;
            messagesContainer.appendChild(errorMessageDiv);
            messagesContainer.scrollTop = messagesContainer.scrollHeight;
        }
    }

    async function sendMessage(message) {
        // Vérifier si la langue sélectionnée est disponible dans la fenêtre parente
        let language = 'fr'; // Par défaut
        
        try {
            if (window.parent && window.parent.selectedLanguage) {
                // Demander la langue à la page parente
                language = window.parent.selectedLanguage;
                console.log("Langue récupérée de la fenêtre parente:", language);
            } else if (window.selectedLanguage) {
                language = window.selectedLanguage;
                console.log("Langue récupérée de la fenêtre actuelle:", language);
            }
        } catch (e) {
            console.warn("Impossible d'accéder à la langue depuis la fenêtre parente");
        }
        
        // Ajouter l'instruction de langue au message
        let finalMessage = message;
        
        // Ajouter l'instruction de langue correspondant à la sélection actuelle
        if (language === 'ar') {
            finalMessage = message + ", Merci de répondre en langue Arabe";
            console.log("Message avec instruction de langue arabe:", finalMessage);
        } else {
            finalMessage = message + ", Merci de répondre en langue français";
            console.log("Message avec instruction de langue française:", finalMessage);
        }
        
        const userMessageDiv = document.createElement('div');
        userMessageDiv.className = 'chat-message user';
        userMessageDiv.textContent = message;
        messagesContainer.appendChild(userMessageDiv);
        messagesContainer.scrollTop = messagesContainer.scrollHeight;
        
        // Show loader while waiting for response
        loader.style.display = 'block';

        try {
            // Ajouter un timeout pour la requête fetch
            const controller = new AbortController();
            const timeoutId = setTimeout(() => controller.abort(), 60000); // 30 secondes timeout
            
            // Utiliser directement finalMessage dans le payload
            const response = await fetch(config.webhook.url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    action: "sendMessage",
                    sessionId: currentSessionId,
                    route: config.webhook.route,
                    chatInput: finalMessage,  // Message avec instruction de langue
                    metadata: {
                        userId: ""
                    }
                }),
                signal: controller.signal
            }).catch(error => {
                if (error.name === 'AbortError') {
                    throw new Error("La requête a pris trop de temps, veuillez réessayer.");
                }
                throw error;
            });
            
            // N'oublions pas d'annuler le timeout
            clearTimeout(timeoutId);
            
            // Vérifier si la réponse est OK
            if (!response.ok) {
                throw new Error(`Erreur HTTP: ${response.status} ${response.statusText}`);
            }
            
            // Vérifier et traiter la réponse avec plus de robustesse
            let text;
            try {
                text = await response.text();
            } catch (error) {
                throw new Error(`Impossible de lire la réponse: ${error.message}`);
            }
            
            if (!text || text.trim() === '') {
                // Si la réponse est vide, on crée une réponse factice pour éviter l'erreur
                console.warn("Réponse vide du serveur, utilisation d'une réponse par défaut");
                text = JSON.stringify({output: "Je n'ai pas pu traiter votre demande. Le serveur n'a pas fourni de réponse."});
            }
            
            // Essayer de parser le JSON avec plus de robustesse
            let data;
            try {
                data = JSON.parse(text);
            } catch (parseError) {
                console.error("Erreur de parsing JSON:", parseError);
                console.log("Réponse reçue:", text);
                
                // Créer une structure de données minimale si le parsing échoue
                data = {
                    output: "Désolé, j'ai reçu une réponse du serveur que je ne peux pas comprendre. Veuillez réessayer."
                };
            }
            
            loader.style.display = 'none';
            
            const botMessageDiv = document.createElement('div');
            botMessageDiv.className = 'chat-message bot';
            
            // Traiter les données avec plus de sécurité
            let botResponse = "Désolé, je n'ai pas pu récupérer une réponse valide.";
            
            if (data) {
                if (Array.isArray(data) && data.length > 0 && data[0].output) {
                    botResponse = data[0].output;
                } else if (!Array.isArray(data) && data.output) {
                    botResponse = data.output;
                }
            }

            // Convertir les \n en <br/> pour le formatage HTML et éviter les doublons
            // 1. Remplacer les sauts de ligne multiples par un seul
            let cleanedResponse = botResponse.replace(/\n{2,}/g, '\n');
            // 2. Convertir les \n en <br/>
            let formattedResponse = cleanedResponse.replace(/\n/g, '<br/>');
            // 3. Éliminer les <br/><br/> ou <br><br> éventuellement présents
            let processedResponse = formattedResponse.replace(/(<br\s*\/?>\s*){2,}/gi, '<br/>');
            // 4. Supprimer les <br/> qui suivent un </li>
            let afterListResponse = processedResponse.replace(/<\/li>\s*<br\s*\/?>/gi, '</li>');
            // 5. Supprimer les <br/> avant <ul>
            let beforeUlResponse = afterListResponse.replace(/<br\s*\/?>\s*<ul/gi, '<ul');
            // 6. Supprimer les <br/> après </ul>
            let afterUlResponse = beforeUlResponse.replace(/<\/ul>\s*<br\s*\/?>/gi, '</ul>');
            // 7. Supprimer les <br/> avant <ol>
            let beforeOlResponse = afterUlResponse.replace(/<br\s*\/?>\s*<ol/gi, '<ol');
            // 8. Supprimer les <br/> après </ol>
            let afterOlResponse = beforeOlResponse.replace(/<\/ol>\s*<br\s*\/?>/gi, '</ol>');
            // 9. Supprimer les <br/> entre <ul> et <li>
            let cleanUlResponse = afterOlResponse.replace(/<ul>\s*<br\s*\/?>/gi, '<ul>');
            // 10. Supprimer les <br/> entre <ol> et <li>
            let finalResponse = cleanUlResponse.replace(/<ol>\s*<br\s*\/?>/gi, '<ol>');
            
            // Utiliser innerHTML pour afficher le contenu formaté
            botMessageDiv.innerHTML = finalResponse;
            
            // Appliquer la direction RTL si la réponse est en arabe
            try {
                if (window.selectedLanguage === 'ar') {
                    botMessageDiv.style.direction = 'rtl';
                    botMessageDiv.style.textAlign = 'right';
                } else {
                    botMessageDiv.style.direction = 'ltr';
                    botMessageDiv.style.textAlign = 'left';
                }
            } catch (e) {
                console.warn("Impossible d'appliquer la direction du texte:", e);
            }
            
            messagesContainer.appendChild(botMessageDiv);
            messagesContainer.scrollTop = messagesContainer.scrollHeight;
        } catch (error) {
            console.error("Error:", error);
            loader.style.display = 'none';
            
            // Afficher un message d'erreur plus informatif dans le chat
            const errorMessageDiv = document.createElement('div');
            errorMessageDiv.className = 'chat-message bot';
            
            let errorMessage = "Impossible de communiquer avec le serveur.";
            if (error.message) {
                if (error.message.includes("JSON")) {
                    errorMessage = "Le serveur a envoyé une réponse que je ne peux pas comprendre.";
                } else if (error.message.includes("HTTP")) {
                    errorMessage = "Erreur de connexion au serveur.";
                } else if (error.message.includes("timeout") || error.message.includes("trop de temps")) {
                    errorMessage = "La connexion au serveur a pris trop de temps.";
                }
            }
            
            errorMessageDiv.innerHTML = `
                <div style="color: #a94442; background-color: #f2dede; padding: 10px; border-radius: 4px; border: 1px solid #ebccd1;">
                    <strong>Désolé, une erreur est survenue.</strong><br>
                    ${errorMessage} Veuillez réessayer plus tard.
                </div>
            `;
            messagesContainer.appendChild(errorMessageDiv);
            messagesContainer.scrollTop = messagesContainer.scrollHeight;
        }
    }

    newChatBtn.addEventListener('click', startNewConversation);
    
    sendButton.addEventListener('click', () => {
        const message = textarea.value.trim();
        if (message) {
            // Mise à jour de la langue juste avant l'envoi
            try {
                if (window.parent && window.parent.selectedLanguage) {
                    // Rafraîchir la langue depuis la fenêtre parente
                    window.selectedLanguage = window.parent.selectedLanguage;
                    console.log("Langue rafraîchie avant envoi:", window.selectedLanguage);
                }
            } catch (e) {
                console.warn("Impossible d'accéder à la fenêtre parente pour la langue");
            }
            
            sendMessage(message);
            textarea.value = '';
        }
    });
    
    textarea.addEventListener('keypress', (e) => {
        if (e.key === 'Enter' && !e.shiftKey) {
            e.preventDefault();
            const message = textarea.value.trim();
            if (message) {
                // Mise à jour de la langue juste avant l'envoi
                try {
                    if (window.parent && window.parent.selectedLanguage) {
                        // Rafraîchir la langue depuis la fenêtre parente
                        window.selectedLanguage = window.parent.selectedLanguage;
                        console.log("Langue rafraîchie avant envoi (touche Enter):", window.selectedLanguage);
                    }
                } catch (e) {
                    console.warn("Impossible d'accéder à la fenêtre parente pour la langue");
                }
                
                sendMessage(message);
                textarea.value = '';
            }
        }
    });
    
    toggleButton.addEventListener('click', () => {
        chatContainer.classList.toggle('open');
    });

    // Add close button handlers
    const closeButtons = chatContainer.querySelectorAll('.close-button');
    closeButtons.forEach(button => {
        button.addEventListener('click', () => {
            chatContainer.classList.remove('open');
        });
    });
})();