<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MAJLISBOT - CSEFRS.ma</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/geist-font/1.0.0/fonts/geist-sans/style.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        :root {
            --primary-color: #a12a2f;
            --primary-color-dark: #8c2529;
            --secondary-color: #2c3e50;
            --accent-color: #3498db;
            --light-bg: #f8f9fa;
            --dark-text: #333;
            --light-text: #fff;
            --gray-bg: #e9ecef;
            --border-radius: 10px;
            --box-shadow: 0 6px 15px rgba(0,0,0,0.1);
            --transition: all 0.3s ease;
        }
        
        body {
            font-family: 'Geist Sans', -apple-system, BlinkMacSystemFont, system-ui, sans-serif;
            margin: 0;
            padding: 0;
            background: linear-gradient(145deg, #f5f7fa 0%, #e4e7eb 100%);
            background-attachment: fixed;
            color: var(--dark-text);
            line-height: 1.6;
            min-height: 100vh;
            scroll-behavior: smooth;
            overflow-x: hidden;
        }
        
        .navbar {
            background-color: var(--primary-color);
            color: var(--light-text);
            padding: 12px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            position: sticky;
            top: 0;
            left: 0;
            right: 0;
            z-index: 100;
            transition: box-shadow 0.3s ease, padding 0.3s ease;
        }
        
        /* Ajouter une ombre plus prononcée lorsque la page défile */
        .navbar.scrolled {
            box-shadow: 0 4px 20px rgba(0,0,0,0.3);
            padding: 8px 20px; /* Légèrement plus compact lors du défilement */
            z-index:9999;
        }
        
        .navbar-brand {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .navbar-logo {
            height: 40px;
            width: auto;
        }
        
        .navbar-title {
            font-size: 20px;
            font-weight: 600;
            margin: 0;
        }
        
        .navbar-controls {
            display: flex;
            align-items: center;
            gap: 20px;
        }
        
        .control-group {
            display: flex;
            align-items: center;
            gap: 10px;
            background-color: rgba(255,255,255,0.1);
            padding: 6px 12px;
            border-radius: 20px;
        }
        
        .control-label {
            font-size: 14px;
            font-weight: 500;
        }
        
        .language-selector {
            padding: 6px;
            border-radius: 4px;
            border: 1px solid rgba(255,255,255,0.3);
            background-color: rgba(255,255,255,0.1);
            color: white;
            cursor: pointer;
            font-size: 14px;
            outline: none;
        }
        
        .language-selector option {
            background-color: var(--secondary-color);
            color: white;
        }
        
        .action-button {
            background-color: rgba(255,255,255,0.15);
            color: white;
            border: none;
            border-radius: 20px;
            padding: 8px 16px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 6px;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .action-button:hover {
            background-color: rgba(255,255,255,0.25);
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }
        
        .action-button:active {
            transform: translateY(1px);
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        .container {
            max-width: 1100px;
            margin: 30px auto;
            padding: 0 20px;
            animation: fadeIn 0.5s ease;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .main-content {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }
        
        .welcome-panel {
            background-color: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            padding: 30px;
            text-align: center;
        }
        
        .welcome-title {
            font-size: 24px;
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 15px;
        }
        
        .welcome-text {
            font-size: 16px;
            color: #555;
            max-width: 800px;
            margin: 0 auto;
        }

        .chat-container-wrapper {
            background-color: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
            position: relative;
            display: flex;
            flex-direction: column;
        }
        
        #chat-container {
            width: 100%;
            height: 100%;
            display: flex;
            flex-direction: column;
            overflow: hidden; /* Important pour empêcher le double scrolling */
        }
        
        .n8n-chat-widget .inline-chat {
            position: relative !important;
            width: 100% !important;
            height: 100% !important;
            display: flex !important;
            flex-direction: column !important;
            border-radius: 0 !important;
            box-shadow: none !important;
            overflow: hidden !important;
            border: none !important;
            margin-top: 0 !important;
        }

        /* Pour éviter des styles conflictuels */
        .n8n-chat-widget .chat-container.position-left {
            left: unset !important;
        }

        .n8n-chat-widget .chat-container.open {
            display: flex !important;
            flex-direction: column !important;
            height: 100% !important;
        }
        
        /* Assurons-nous que le conteneur du widget prend toute la hauteur */
        .n8n-chat-widget .chat-container {
            display: flex !important;
            flex-direction: column !important;
            height: 100% !important;
            overflow: hidden !important;
        }
        
        #chat-container div.chat-messages h1 {
            font-size: 22px;
            text-align: left;
            font-weight: bold;
        }
        
        
        .brand-header {
            display: none !important;
        }

        /* Forcer la zone de chat à occuper toute la hauteur avec structure scrollable */
        .n8n-chat-widget .chat-interface {
          display: flex;
          flex-direction: column;
          height: 100%;
          position: relative;
        }

        /* Rendre uniquement la partie messages scrollable */
        .n8n-chat-widget .chat-messages {
          flex: 1 1 auto;
          overflow-y: auto;
          padding: 20px;
          padding-bottom: 120px; /* Espace pour le chat-input fixe en bas */
          scroll-behavior: smooth;
          height: calc(100% - 150px); /* Calculer l'espace disponible */
          overscroll-behavior: contain; /* Empêcher le scroll de propager au conteneur parent */
        }
        
        /* Style des messages pour meilleure apparence */
        .n8n-chat-widget .chat-message {
          max-width: 85%;
          padding: 12px 16px;
          margin-bottom: 12px;
          border-radius: 12px;
          box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
          position: relative;
          word-break: break-word;
        }
        
        /* Style spécifique messages utilisateur */
        .n8n-chat-widget .chat-message.user {
          background-color: var(--primary-color);
          color: white;
          align-self: flex-end;
          border-bottom-right-radius: 4px;
          margin-left: auto;
        }
        
        /* Style spécifique messages bot */
        .n8n-chat-widget .chat-message.bot {
          background-color: #f5f7fa;
          color: var(--dark-text);
          align-self: flex-start;
          border-bottom-left-radius: 4px;
          margin-right: auto;
        }

        /* Chat loader sticky en bas */
        .n8n-chat-widget .chat-loader {
          position: sticky;
          bottom: 80px; /* Juste au-dessus de la barre de saisie */
          left: 0;
          right: 0;
          z-index: 15;
          margin-top: auto;
        }

        /* Input sticky en bas */
        .n8n-chat-widget .chat-input {
          position: sticky;
          bottom: 40px; /* Au-dessus du footer */
          left: 0;
          right: 0;
          background: white;
          z-index: 10;
          box-shadow: 0 -4px 12px rgba(0, 0, 0, 0.05);
          padding: 12px 16px;
          display: flex;
          align-items: center;
          border-top: 1px solid rgba(0, 0, 0, 0.05);
          margin-top: auto; /* Pousse le chat-input vers le bas de son conteneur */
        }
        
        /* Assurer que le textarea prend suffisamment de place */
        .n8n-chat-widget .chat-input textarea {
          flex: 1;
          min-height: 40px;
          max-height: 80px;
          padding: 10px 12px;
          border-radius: 8px;
          border: 1px solid rgba(0, 0, 0, 0.1);
          resize: none;
          font-family: inherit;
          font-size: 14px;
          outline: none;
          transition: border-color 0.3s ease;
        }
        
        .n8n-chat-widget .chat-input textarea:focus {
          border-color: var(--primary-color);
          box-shadow: 0 0 0 2px rgba(161, 42, 47, 0.1);
        }

        /* Footer sticky en bas */
        .n8n-chat-widget .chat-footer {
          position: sticky;
          bottom: 0;
          left: 0;
          right: 0;
          z-index: 5;
          background: white;
          padding: 8px;
          border-top: 1px solid rgba(133, 79, 255, 0.1);
        }

        /* Style pour le bouton microphone dans la zone de chat */
        #microphone-button-chat {
          background: var(--primary-color); 
          color: white; 
          border: none; 
          border-radius: 50%;
          width: 40px; 
          height: 40px; 
          font-size: 20px; 
          cursor: pointer; 
          display: flex; 
          align-items: center; 
          justify-content: center;
          margin-right: 8px;
          transition: var(--transition);
        }

        #microphone-button-chat:hover {
          background: #d9534f;
        }
        
        /* Animation de chargement */
        @keyframes loading {
            0% { opacity: 0.2; }
            20% { opacity: 1; }
            100% { opacity: 0.2; }
        }
        
        .loading-dots span {
            animation: loading 1s infinite;
            animation-fill-mode: both;
        }
        
        .loading-dots span:nth-child(2) {
            animation-delay: 0.2s;
        }
        
        .loading-dots span:nth-child(3) {
            animation-delay: 0.4s;
        }
        
        .footer {
            text-align: center;
            padding: 20px;
            font-size: 14px;
            color: #666;
            margin-top: 30px;
        }
        
        .footer a {
            color: var(--primary-color);
            text-decoration: none;
        }
        
        /* Styles responsive */
        @media (max-width: 768px) {
            .navbar {
                flex-direction: column;
                padding: 10px;
            }
            
            .navbar-controls {
                width: 100%;
                justify-content: center;
                margin-top: 10px;
                flex-wrap: wrap;
            }
            
            .welcome-panel {
                padding: 20px;
            }
            
            .chat-container-wrapper {
                height: 500px;
            }
        }
    </style>
</head>
<body>
    <!-- Barre de navigation -->
    <div class="navbar">
        <div class="navbar-brand">
            <img src="/private/img/logo_csefrs.png" alt="CSEFRS logo" class="navbar-logo "style="border-radius: 5px;border: 5px solid #FFFFFF;">
            <h1 class="navbar-title">MAJLISBOT</h1>
        </div>
        <div class="navbar-controls">
            <div class="control-group">
                <span class="control-label">Langue des réponses de MajlisBOT:</span>
                <select id="language-selector" class="language-selector">
                    <option value="fr" selected>Français</option>
                    <option value="ar">العربية (Arabe)</option>
                </select>
            </div>
            <button id="reset-chat" class="action-button">
                <i class="fas fa-redo-alt"></i> Réinitialiser le chat
            </button>
        </div>
    </div>
    
    <!-- Contenu principal -->
    <div class="container">
        <div class="main-content">
            <div class="welcome-panel">
                <div class="welcome-title">Bienvenue sur MAJLISBOT</div>
                <p class="welcome-text">
                    Votre assistant conversationnel intelligent relatif aux publications du Conseil Supérieur de l'Éducation, 
                    de la Formation et de la Recherche scientifique.
                </p>
            </div>
            
            <!-- Zone pour le chat -->
            <div class="chat-container-wrapper">
                <div id="chat-container"></div>
            </div>
        </div>
    </div>
    
    <!-- Pied de page -->
    <div class="footer">
        &copy; 2025 CSEFRS - Tous droits réservés | <a href="https://csefrs.ma" target="_blank">csefrs.ma</a>
    </div>

    <!-- Widget Configuration -->
    <script>
    // Variable pour stocker la langue sélectionnée
    let selectedLanguage = 'fr';
    
    // Écouter les changements du sélecteur de langue
    document.getElementById('language-selector').addEventListener('change', (e) => {
        // Mettre à jour la langue sélectionnée
        selectedLanguage = e.target.value;
        console.log("Langue sélectionnée:", selectedLanguage);
        
        // SOLUTION 1: Définir directement la variable
        window.selectedLanguage = selectedLanguage;
        
        // SOLUTION 2: Essayer de définir la variable dans l'iframe 
        try {
            const chatFrames = document.querySelectorAll('#chat-container iframe');
            chatFrames.forEach(frame => {
                try {
                    if (frame && frame.contentWindow) {
                        // Définir la variable directement dans l'iframe
                        frame.contentWindow.selectedLanguage = selectedLanguage;
                        console.log("Langue définie dans l'iframe");
                    }
                } catch (frameError) {
                    console.warn("Impossible d'accéder à cet iframe:", frameError);
                }
            });
        } catch (e) {
            console.warn("Erreur lors de la définition de la langue dans les iframes:", e);
        }
        
        // SOLUTION 3: Méthode postMessage pour contourner les restrictions de sécurité cross-origin
        try {
            const chatFrames = document.querySelectorAll('#chat-container iframe');
            chatFrames.forEach(frame => {
                try {
                    if (frame && frame.contentWindow) {
                        frame.contentWindow.postMessage({
                            type: 'setLanguage',
                            language: selectedLanguage
                        }, '*');
                        console.log("Message envoyé à l'iframe pour définir la langue");
                    }
                } catch (frameError) {
                    console.warn("Impossible d'envoyer un message à cet iframe:", frameError);
                }
            });
        } catch (e) {
            console.warn("Erreur lors de l'envoi de message aux iframes:", e);
        }
    });
    
    // Fonction pour réinitialiser le chat
    function resetChat() {
        // Afficher un message de confirmation
        if (confirm("Êtes-vous sûr de vouloir réinitialiser le chat ? Toute la conversation sera perdue.")) {
            console.log("Réinitialisation du chat...");
            
            // 1. Supprimer les données de session
            localStorage.removeItem('csefrs_bot_language');
            localStorage.removeItem('csefrs_chat_session');
            
            // 2. Recharger la page
            window.location.reload();
        }
    }
    
    // Ajouter un gestionnaire d'événements pour le bouton de réinitialisation
    document.getElementById('reset-chat').addEventListener('click', resetChat);
    
    // Force le français comme langue par défaut à chaque chargement
    selectedLanguage = 'fr';
    document.getElementById('language-selector').value = 'fr';
    
    // Configuration du chat
    window.ChatWidgetConfig = {
        webhook: {
            url: 'https://automat.projects-dev.com/webhook/689f3b06-c62b-4257-a3d5-7b6ac30e4c0b/chat',
            route: 'general'
        },
        branding: {
            logo: '/private/img/logo_csefrs.png',
            name: 'CSEFRS',
            welcomeText: 'Bonjour 👋, Comment je peux vous aider ?',
            responseTimeText: 'Nous répondons généralement immédiatement.'
        },
        style: {
            primaryColor: '#a12a2f',
            secondaryColor: '#a94145',
            backgroundColor: '#ffffff',
            fontColor: '#333333',
            inline: true,
            containerId: 'chat-container'
        }
    };
    
    // Initialiser le chat lorsque la page est chargée
    // Fonction pour gérer l'effet de la navbar lors du défilement
    function handleScrollEffects() {
        const navbar = document.querySelector('.navbar');
        if (window.scrollY > 10) {
            navbar.classList.add('scrolled');
        } else {
            navbar.classList.remove('scrolled');
        }
    }
    
    // Ajouter l'écouteur d'événement de défilement
    window.addEventListener('scroll', handleScrollEffects);
    
    // Initialiser l'effet de la navbar au chargement de la page
    window.addEventListener('load', function () {
        handleScrollEffects();
        
        const widgetWrapper = document.querySelector('.n8n-chat-widget');
        const target = document.getElementById('chat-container');

        if (widgetWrapper && target) {
            target.appendChild(widgetWrapper);

            // Forcer style inline
            const container = widgetWrapper.querySelector('.chat-container');
            if (container) {
                container.classList.add('open');
                container.style.position = 'relative';
                container.style.bottom = 'unset';
                container.style.right = 'unset';
                container.style.width = '100%';
                container.style.height = '100%';
            }

            // Simuler le clic "Commencer la discussion"
            const newChatButton = widgetWrapper.querySelector('.new-chat-btn');
            if (newChatButton) {
                newChatButton.click();
            }

            // Cacher le bouton flottant
            const toggleBtn = widgetWrapper.querySelector('.chat-toggle');
            if (toggleBtn) {
                toggleBtn.style.display = 'none';
            }
            
            // Synchroniser la langue avec l'iframe dès le chargement
            setTimeout(() => {
                try {
                    const chatFrames = document.querySelectorAll('#chat-container iframe');
                    chatFrames.forEach(frame => {
                        if (frame && frame.contentWindow) {
                            // Définir la variable directement
                            frame.contentWindow.selectedLanguage = 'fr';
                            // Et envoyer un message pour plus de sécurité
                            frame.contentWindow.postMessage({
                                type: 'setLanguage',
                                language: 'fr'
                            }, '*');
                            console.log("Langue française forcée dans l'iframe au chargement");
                        }
                    });
                } catch (e) {
                    console.warn("Erreur lors de l'initialisation de la langue dans l'iframe:", e);
                }
            }, 2000); // Délai pour s'assurer que l'iframe est chargée
        }
    });
    </script>
    <script src="/private/js/chat-widget.js"></script>
    <script>
    // Compteur de réponses bot
    let botMessageCount = 0;

    function addCopyButtonToBotMessage(messageDiv) {
        // Ne rien faire pour la première réponse
        if (botMessageCount === 0) {
            botMessageCount++;
            return;
        }

        const copyBtn = document.createElement("button");
        copyBtn.innerHTML = '<i class="far fa-clipboard"></i> Copier';
        copyBtn.style.marginTop = "8px";
        copyBtn.style.alignSelf = "flex-end";
        copyBtn.style.padding = "6px 12px";
        copyBtn.style.border = "1px solid #AAA";
        copyBtn.style.borderRadius = "6px";
        copyBtn.style.backgroundColor = "rgb(255, 255, 255)";
        copyBtn.style.color = "#626262";
        copyBtn.style.cursor = "pointer";
        copyBtn.style.fontSize = "12px";

        copyBtn.addEventListener("click", () => {
            // Cloner le message sans le bouton
            const messageClone = messageDiv.cloneNode(true);
            const buttonInClone = messageClone.querySelector('button');
            if (buttonInClone) {
                buttonInClone.remove();
            }

            const tempTextarea = document.createElement("textarea");
            tempTextarea.value = messageClone.innerText;
            document.body.appendChild(tempTextarea);
            tempTextarea.select();
            document.execCommand("copy");
            document.body.removeChild(tempTextarea);

            copyBtn.innerHTML = '<i class="fas fa-check"></i> Copié !';
            setTimeout(() => copyBtn.innerHTML = '<i class="far fa-clipboard"></i> Copier', 2000);
        });

        messageDiv.appendChild(copyBtn);
        botMessageCount++;
    }

    const observer = new MutationObserver(mutations => {
        mutations.forEach(mutation => {
            mutation.addedNodes.forEach(node => {
                if (node.nodeType === 1 && node.classList.contains("chat-message") && node.classList.contains("bot")) {
                    // Ajouter le bouton Copier
                    addCopyButtonToBotMessage(node);
                    
                    // Lecture audio si activée
                    try {
                        // ttsEnabled est défini dans le script d'enregistrement audio
                        if (typeof window.ttsEnabled !== 'undefined') {
                            const textToRead = getCleanedTextFromBotMessage(node);
                            if (window.ttsEnabled && textToRead.length > 0) {
                                console.log("Lecture audio activée pour le message:", textToRead.substring(0, 50) + "...");
                                speakWithElevenLabs(textToRead);
                            }
                        }
                    } catch (e) {
                        console.warn("Erreur lors de la vérification de la lecture audio:", e);
                    }
                }
            });
        });
    });

    window.addEventListener('load', () => {
        const chatMessages = document.querySelector('.chat-messages');
        if (chatMessages) {
            observer.observe(chatMessages, { childList: true });
        }
    });
</script>

<script>
    const elevenLabsApiKey = 'sk_bdc707cafc5d3e7e5196ee71e76e6930d2ff4d75ff3397b0';
    const voiceId = 'oeFgBesnArgN0SVGZu8Z'; // ex: Rachel, change si besoin

    function getCleanedTextFromBotMessage(node) {
        // Cloner le message
        const clone = node.cloneNode(true);
    
        // Supprimer le bouton "Copier" du clone
        const button = clone.querySelector('button');
        if (button) button.remove();
    
        return clone.innerText.trim();
    }

    async function speakWithElevenLabs(text) {
        const response = await fetch(`https://api.elevenlabs.io/v1/text-to-speech/${voiceId}`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'xi-api-key': elevenLabsApiKey
            },
            body: JSON.stringify({
                text: text,
                model_id: 'eleven_turbo_v2_5', // ou 'eleven_multilingual_v1'
                voice_settings: {
                     stability:0.0,
                    similarity_boost:1.0,
                    style:0.0,
                    use_speaker_boost:true,
                    speed:1.0,
                }
            })
        });

        const audioBlob = await response.blob();
        const audioUrl = URL.createObjectURL(audioBlob);
        const audio = new Audio(audioUrl);
        audio.play();
    }
</script>

<!-- Script d'enregistrement audio -->
<script>
    // Variables pour l'enregistrement audio et la lecture des réponses
    let mediaRecorder = null;
    let audioChunks = [];
    let audioRecording = false;
    let audioBlob = null;
    let recordButton = null;
    let ttsButton = null;
    
    // Utiliser window.ttsEnabled pour accès global
    window.ttsEnabled = false;
    
    // Fonction pour créer les boutons audio (enregistrement et lecture)
    function createAudioRecordButton() {
        const chatInput = document.querySelector('.n8n-chat-widget .chat-input');
        if (!chatInput) return;
        
        // 1. Créer le bouton d'enregistrement audio
        recordButton = document.createElement('button');
        recordButton.id = 'audio-record-button';
        recordButton.title = 'Enregistrer un message audio';
        recordButton.innerHTML = '<i class="fas fa-microphone-alt"></i>';
        recordButton.style.backgroundColor = '#2c3e50';
        recordButton.style.color = 'white';
        recordButton.style.border = 'none';
        recordButton.style.borderRadius = '50%';
        recordButton.style.width = '40px';
        recordButton.style.height = '40px';
        recordButton.style.fontSize = '16px';
        recordButton.style.cursor = 'pointer';
        recordButton.style.display = 'flex';
        recordButton.style.alignItems = 'center';
        recordButton.style.justifyContent = 'center';
        recordButton.style.marginRight = '8px';
        recordButton.style.transition = 'all 0.3s ease';
        
        // 2. Créer le bouton de lecture des réponses du bot
        ttsButton = document.createElement('button');
        ttsButton.id = 'tts-toggle-button';
        ttsButton.title = 'Activer/désactiver la lecture des réponses';
        ttsButton.innerHTML = '<i class="fas fa-volume-mute"></i>';
        ttsButton.style.backgroundColor = '#7f8c8d'; // Gris (désactivé)
        ttsButton.style.color = 'white';
        ttsButton.style.border = 'none';
        ttsButton.style.borderRadius = '50%';
        ttsButton.style.width = '40px';
        ttsButton.style.height = '40px';
        ttsButton.style.fontSize = '16px';
        ttsButton.style.cursor = 'pointer';
        ttsButton.style.display = 'flex';
        ttsButton.style.alignItems = 'center';
        ttsButton.style.justifyContent = 'center';
        ttsButton.style.marginRight = '8px';
        ttsButton.style.transition = 'all 0.3s ease';
        
        // Ajouter les boutons avant le textarea
        const textarea = chatInput.querySelector('textarea');
        
        if (textarea) {
            // Ajouter avant le textarea
            chatInput.insertBefore(recordButton, textarea);
            chatInput.insertBefore(ttsButton, textarea);
        }
        
        // Ajouter les événements
        recordButton.addEventListener('click', toggleAudioRecording);
        ttsButton.addEventListener('click', toggleTTS);
    }
    
    // Fonction pour activer/désactiver la lecture des réponses
    function toggleTTS() {
        window.ttsEnabled = !window.ttsEnabled;
        
        // Mettre à jour l'apparence du bouton
        if (window.ttsEnabled) {
            ttsButton.style.backgroundColor = '#27ae60'; // Vert (activé)
            ttsButton.innerHTML = '<i class="fas fa-volume-up"></i>';
            ttsButton.title = 'Désactiver la lecture des réponses';
            console.log("Lecture audio des réponses activée");
        } else {
            ttsButton.style.backgroundColor = '#7f8c8d'; // Gris (désactivé)
            ttsButton.innerHTML = '<i class="fas fa-volume-mute"></i>';
            ttsButton.title = 'Activer la lecture des réponses';
            console.log("Lecture audio des réponses désactivée");
        }
    }
    
    // Fonction pour démarrer/arrêter l'enregistrement audio
    async function toggleAudioRecording() {
        if (audioRecording) {
            // Arrêter l'enregistrement
            stopAudioRecording();
        } else {
            // Démarrer l'enregistrement
            try {
                const stream = await navigator.mediaDevices.getUserMedia({ audio: true });
                startAudioRecording(stream);
            } catch (error) {
                console.error("Erreur lors de l'accès au microphone:", error);
                alert("Impossible d'accéder au microphone. Veuillez vérifier vos permissions.");
            }
        }
    }
    
    // Démarrer l'enregistrement audio
    function startAudioRecording(stream) {
        audioChunks = [];
        audioRecording = true;
        
        // Mettre à jour l'apparence du bouton
        recordButton.style.backgroundColor = '#e74c3c';
        recordButton.innerHTML = '<i class="fas fa-stop"></i>';
        
        // Créer le MediaRecorder avec une meilleure qualité audio
        const options = {
            audioBitsPerSecond: 128000, // 128 kbps
            mimeType: 'audio/webm;codecs=opus' // Format optimal pour la voix
        };
        
        try {
            // Essayer d'utiliser les options optimales
            mediaRecorder = new MediaRecorder(stream, options);
            console.log("Enregistrement audio en haute qualité activé");
        } catch (e) {
            // Fallback vers les options par défaut si non supportées
            console.warn("Options d'enregistrement audio non supportées, utilisation des options par défaut");
            mediaRecorder = new MediaRecorder(stream);
        }
        
        // Événement pour collecter les données
        mediaRecorder.ondataavailable = (event) => {
            if (event.data.size > 0) {
                audioChunks.push(event.data);
            }
        };
        
        // Événement quand l'enregistrement est terminé
        mediaRecorder.onstop = async () => {
            // Créer un blob à partir des chunks audio
            audioBlob = new Blob(audioChunks, { type: 'audio/wav' });
            
            // Créer un élément audio (temporaire pour la transcription)
            const audioURL = URL.createObjectURL(audioBlob);
            
            // Afficher un message de chargement détaillé
            const tempMessage = addTemporaryMessage("Traitement de votre message vocal en cours... Je vais transcrire votre audio puis vous répondre.");
            
            try {
                // Transcription via API ElevenLabs
                const transcription = await transcribeAudio(audioBlob);
                
                // Ajouter le message audio
                addAudioMessage(audioURL, transcription);
                
                // Supprimer le message temporaire
                if (tempMessage && tempMessage.parentNode) {
                    tempMessage.parentNode.removeChild(tempMessage);
                }
                
                // Envoyer le message au bot (utiliser la transcription)
                const chatTextarea = document.querySelector('.n8n-chat-widget .chat-input textarea');
                const sendButton = document.querySelector('.n8n-chat-widget .chat-input button[type="submit"]');
                
                if (chatTextarea && sendButton) {
                    chatTextarea.value = transcription;
                    sendButton.click();
                }
            } catch (error) {
                console.error("Erreur lors du traitement audio:", error);
                if (tempMessage && tempMessage.parentNode) {
                    tempMessage.parentNode.removeChild(tempMessage);
                }
                alert("Erreur lors du traitement de l'audio. Veuillez réessayer.");
            }
            
            // Arrêter les pistes du stream
            mediaRecorder.stream.getTracks().forEach(track => track.stop());
        };
        
        // Démarrer l'enregistrement
        mediaRecorder.start();
    }
    
    // Arrêter l'enregistrement audio
    function stopAudioRecording() {
        if (mediaRecorder && audioRecording) {
            audioRecording = false;
            
            // Mettre à jour l'apparence du bouton
            recordButton.style.backgroundColor = '#2c3e50';
            recordButton.innerHTML = '<i class="fas fa-microphone-alt"></i>';
            
            // Arrêter l'enregistrement
            mediaRecorder.stop();
        }
    }
    
    // Ajouter un message temporaire pendant le traitement
    function addTemporaryMessage(text) {
        const messagesContainer = document.querySelector('.n8n-chat-widget .chat-messages');
        if (!messagesContainer) return null;
        
        const messageDiv = document.createElement('div');
        messageDiv.className = 'chat-message bot';
        messageDiv.style.opacity = '0.7';
        messageDiv.innerHTML = `<div>${text}</div><div class="loading-dots"><span>.</span><span>.</span><span>.</span></div>`;
                
        messagesContainer.appendChild(messageDiv);
        messagesContainer.scrollTop = messagesContainer.scrollHeight;
        
        return messageDiv;
    }
    
    // Ajouter un message audio dans le chat
    function addAudioMessage(audioURL, transcription = "") {
        const messagesContainer = document.querySelector('.n8n-chat-widget .chat-messages');
        if (!messagesContainer) return;
        
        // Créer le message
        const messageDiv = document.createElement('div');
        messageDiv.className = 'chat-message user audio-message';
        
        // Créer le conteneur pour le lecteur audio
        const audioContainer = document.createElement('div');
        audioContainer.className = 'audio-player-container';
        
        // Créer l'élément audio
        const audioElement = document.createElement('audio');
        audioElement.controls = true;
        audioElement.className = 'audio-player';
        audioElement.src = audioURL;
        
        // Ajouter l'audio au conteneur
        audioContainer.appendChild(audioElement);
        
        // Créer la transcription si disponible
        let transcriptionElement = '';
        if (transcription) {
            transcriptionElement = `<div class="audio-transcription">"${transcription}"</div>`;
        }
        
        // Assembler le message
        messageDiv.innerHTML = `
            <div>Message audio:</div>
            ${audioContainer.outerHTML}
            ${transcriptionElement}
        `;
        
        // Ajouter à la conversation
        messagesContainer.appendChild(messageDiv);
        messagesContainer.scrollTop = messagesContainer.scrollHeight;
    }
    
    // Fonction pour transcription audio avec l'API ElevenLabs Speech-to-Text
    async function transcribeAudio(audioBlob) {
        return new Promise(async (resolve, reject) => {
            try {
                // Utiliser la même clé API que pour la synthèse vocale
                const elevenLabsApiKey = 'sk_bdc707cafc5d3e7e5196ee71e76e6930d2ff4d75ff3397b0';
                
                // Créer un FormData pour envoyer le fichier audio
                const formData = new FormData();
                
                // Vérifier que le blob est correct et convertir en fichier avec bon type MIME
                console.log("Taille du blob audio:", Math.round(audioBlob.size / 1024), "KB");
                
                // Paramètres selon la documentation officielle
                // https://elevenlabs.io/docs/api-reference/speech-to-text/convert
                formData.append('file', audioBlob, 'recording.wav'); // Le paramètre doit être 'file' et non 'audio'
                formData.append('model_id', 'scribe_v1');           // Le seul modèle disponible
                formData.append('language_code', 'fr');             // Code de langue français
                
                // Options supplémentaires
                formData.append('tag_audio_events', 'false');       // Ne pas taguer les événements audio
                formData.append('diarize', 'false');                // Pas besoin d'identification de locuteur
                
                // Log des paramètres pour débogage
                console.log("Paramètres envoyés:", {
                    "model_id": "scribe_v1", 
                    "language_code": "fr",
                    "audio_size_kb": Math.round(audioBlob.size / 1024)
                });
                
                // Afficher un message dans la console pour le débogage
                console.log("Envoi de l'audio à ElevenLabs pour transcription...");
                
                // Appeler l'API ElevenLabs pour la transcription
                const response = await fetch('https://api.elevenlabs.io/v1/speech-to-text', {
                    method: 'POST',
                    headers: {
                        'xi-api-key': elevenLabsApiKey,
                        // Ne pas définir Content-Type, il sera automatiquement défini avec la boundary pour FormData
                    },
                    body: formData
                });
                
                // Vérifier si la requête a réussi
                if (!response.ok) {
                    const errorData = await response.json().catch(() => null);
                    console.error("Erreur de l'API ElevenLabs:", errorData || response.statusText);
                    
                    // Si l'API échoue, utiliser une solution de secours locale
                    return fallbackTranscription(audioBlob);
                }
                
                // Traiter la réponse
                const data = await response.json();
                console.log("Réponse de l'API ElevenLabs:", data);
                
                // Selon la documentation, le format de réponse contient directement un champ 'text'
                if (data && data.text) {
                    // Logguer des informations supplémentaires si disponibles
                    if (data.language_code) {
                        console.log("Langue détectée:", data.language_code, 
                                   "avec probabilité:", data.language_probability || "N/A");
                    }
                    
                    // Retourner le texte transcrit
                    resolve(data.text);
                } else {
                    console.warn("Format de réponse inattendu:", data);
                    // Utiliser une solution de secours si le format est inattendu
                    return fallbackTranscription(audioBlob);
                }
            } catch (error) {
                console.error("Erreur lors de la transcription avec ElevenLabs:", error);
                // En cas d'erreur, utiliser une solution de secours
                return fallbackTranscription(audioBlob);
            }
        });
    }
    
    // Fonction de secours pour la transcription si ElevenLabs échoue
    async function fallbackTranscription(audioBlob) {
        return new Promise((resolve) => {
            console.log("Utilisation de la transcription de secours...");
            
            // Si disponible, on pourrait utiliser la Web Speech API comme solution de secours
            // Pour l'instant, renvoyer un message par défaut
            setTimeout(() => {
                resolve("Message audio envoyé. La transcription n'a pas pu être générée.");
            }, 1000);
        });
    }
    
    // Initialiser le bouton d'enregistrement audio au chargement
    window.addEventListener('load', function() {
        setTimeout(createAudioRecordButton, 2500);
    });
</script>

</body>
</html>